local t = Def.ActorFrame{};

local function GetSongRadarValues(pn,rc) return GetCurrentSteps(pn):GetRadarValues(pn):GetValue(rc) end -- Song Radar Values
local function GetPlayedRadarValues(pn,rc) return STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats(pn):GetRadarActual(pn):GetValue(rc) end -- Played Radar Values
local function GetAccumStats(pn,tns) return STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(pn):GetTapNoteScores(tns) end
local function TNS(pn,i) return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetTapNoteScores(i) end -- Current TapNoteScore
local function HNS(pn,i) return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetHoldNoteScores(i) end -- Current HoldNoteScore
local function MaxCombo(pn) return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):MaxCombo() end -- Current MaxCombo
local function IsW5Disabled() if PREFSMAN:GetPreference("TimingWindowSecondsW5") == 0 then return true else return false end end

t[#t+1] = Def.ActorFrame{
	Miso()..{
		Name="Perfect+ Label";
		InitCommand=cmd(xy,CenterX(),CenterY()-40;zoom,0.8;valign,0;diffuse,color(jColors[1]));
		OnCommand=function(self) self:settext("PERFECT") end;
	};
	Miso()..{
		Name="Perfect Label";
		InitCommand=cmd(xy,CenterX(),CenterY()-40+22;zoom,0.8;valign,0;diffuse,color(jColors[2]));
		OnCommand=function(self) self:settext("PERFECT") end;
	};
	Miso()..{
		Name="Great Label";
		InitCommand=cmd(xy,CenterX(),CenterY()-40+22*2;zoom,0.8;valign,0;diffuse,color(jColors[3]));
		OnCommand=function(self) self:settext("GREAT") end;
	};
	Miso()..{
		Name="Good Label";
		InitCommand=cmd(xy,CenterX(),CenterY()-40+22*3;zoom,0.8;valign,0;diffuse,color(jColors[4]));
		OnCommand=function(self) self:settext("GOOD") end;
	};
	Miso()..{
		Name="Bad Label";
		InitCommand=cmd(xy,CenterX(),CenterY()-40+22*4;zoom,0.8;valign,0;diffuse,color(jColors[5]));
		OnCommand=function(self) if not IsW5Disabled() then self:settext("BAD") end end;
	};
	Miso()..{
		Name="Miss Label";
		InitCommand=cmd(xy,CenterX(),CenterY()-40+22*(IsW5Disabled() and 4 or 5);zoom,0.8;valign,0;diffuse,color(jColors[6]));
		OnCommand=function(self) self:settext("MISS") end;
	};
	Miso()..{
		Name="Max Combo Label";
		InitCommand=cmd(xy,CenterX(),CenterY()+16*(IsW5Disabled() and 5 or 6);zoom,0.5;valign,0);
		OnCommand=function(self) self:settext("MAX COMBO") end;
	};
	Miso()..{
		Name="Holds Label";
		InitCommand=cmd(xy,CenterX(),CenterY()+16*(IsW5Disabled() and 6 or 7);zoom,0.5;valign,0);
		OnCommand=function(self) self:settext("HOLDS") end;
	};
	Miso()..{
		Name="Mines Label";
		InitCommand=cmd(xy,CenterX(),CenterY()+16*(IsW5Disabled() and 7 or 8);zoom,0.5;valign,0);
		OnCommand=function(self) self:settext("MINES") end;
	};
	Miso()..{
		Name="Hands Label";
		InitCommand=cmd(xy,CenterX(),CenterY()+16*(IsW5Disabled() and 8 or 9);zoom,0.5;valign,0);
		OnCommand=function(self) self:settext("HANDS") end;
	};
};

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		MisoBold()..{
			Name="Perfect+ Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-64) else self:x(CenterX()+64) end self:y(CenterY()-39):zoom(0.8):valign(0):diffuse(color(jColors[1])):shadowlength(1) end;
			OnCommand=function(self) self:settext(string.format("%04.f",TNS(pn,9))):AddAttribute(0,{Length = LeadingToFourZeros(pn,9); Diffuse = ColorDarkTone(color(jColors[1]))}) end;
		};
		MisoBold()..{
			Name="Perfect Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-64) else self:x(CenterX()+64) end self:y(CenterY()-39+22):zoom(0.8):valign(0):diffuse(color(jColors[2])):shadowlength(1) end;
			OnCommand=function(self) self:settext(string.format("%04.f",TNS(pn,8))):AddAttribute(0,{Length = LeadingToFourZeros(pn,8); Diffuse = ColorDarkTone(color(jColors[2]))}) end;
		};
		MisoBold()..{
			Name="Great Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-64) else self:x(CenterX()+64) end self:y(CenterY()-39+22*2):zoom(0.8):valign(0):diffuse(color(jColors[3])):shadowlength(1) end;
			OnCommand=function(self) self:settext(string.format("%04.f",TNS(pn,7))):AddAttribute(0,{Length = LeadingToFourZeros(pn,7); Diffuse = ColorDarkTone(color(jColors[3]))}) end;
		};
		MisoBold()..{
			Name="Good Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-64) else self:x(CenterX()+64) end self:y(CenterY()-39+22*3):zoom(0.8):valign(0):diffuse(color(jColors[4])):shadowlength(1) end;
			OnCommand=function(self) self:settext(string.format("%04.f",TNS(pn,6))):AddAttribute(0,{Length = LeadingToFourZeros(pn,6); Diffuse = ColorDarkTone(color(jColors[4]))}) end;
		};
		MisoBold()..{
			Name="Bad Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-64) else self:x(CenterX()+64) end self:y(CenterY()-39+22*4):zoom(0.8):valign(0):diffuse(color(jColors[5])):shadowlength(1) end;
			OnCommand=function(self) if not IsW5Disabled() then self:settext(string.format("%04.f",TNS(pn,5))):AddAttribute(0,{Length = LeadingToFourZeros(pn,5); Diffuse = ColorDarkTone(color(jColors[5]))}) end end;
		};
		MisoBold()..{
			Name="Miss Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-64) else self:x(CenterX()+64) end self:y(CenterY()-39+22*(IsW5Disabled() and 4 or 5)):zoom(0.8):valign(0):diffuse(color(jColors[6])):shadowlength(1) end;
			OnCommand=function(self) self:settext(string.format("%04.f",TNS(pn,4))):AddAttribute(0,{Length = LeadingToFourZeros(pn,4); Diffuse = ColorDarkTone(color(jColors[6]))}) end;
		};
		MisoBold()..{
			Name="Max Combo Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-57) else self:x(CenterX()+57) end self:y(CenterY()+1+16*(IsW5Disabled() and 5 or 6)):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext(string.format("%05.f",MaxCombo(pn))):AddAttribute(0,{Length = LeadingToFiveZerosForMaxCombo(pn); Diffuse = ColorDarkTone(White())}) end;
		};
		MisoBold()..{
			Name="Holds Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-48) else self:x(CenterX()+48) end self:y(CenterY()+1+16*(IsW5Disabled() and 6 or 7)):zoom(0.5):valign(0):shadowlength(1):diffuse(ColorDarkTone(White())) end;
			OnCommand=function(self) self:settext(string.format("%03.f",HNS(pn,2)).." / "..string.format("%03.0f",GetSongRadarValues(pn,7) + GetSongRadarValues(pn,10))) end;
		};
		MisoBold()..{
			Name="Mines Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-48) else self:x(CenterX()+48) end self:y(CenterY()+1+16*(IsW5Disabled() and 7 or 8)):zoom(0.5):valign(0):shadowlength(1):diffuse(ColorDarkTone(White())) end;
			OnCommand=function(self) self:settext(string.format("%03.f",GetPlayedRadarValues(pn,8)).." / "..string.format("%03.0f",GetSongRadarValues(pn,8))) end;
		};
		MisoBold()..{
			Name="Hands Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(CenterX()-48) else self:x(CenterX()+48) end self:y(CenterY()+1+16*(IsW5Disabled() and 8 or 9)):zoom(0.5):valign(0):shadowlength(1):diffuse(ColorDarkTone(White())) end;
			OnCommand=function(self) self:settext(string.format("%03.f",GetPlayedRadarValues(pn,9)).." / "..string.format("%03.0f",GetSongRadarValues(pn,9))) end;
		};
	};
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		CommonNormal()..{
			Name = "Top 4 Best Scores";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(Top()+136):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext("TOP 4 BEST SCORES"):diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)) end;
		};
	};
	for i = 1,4 do
		t[#t+1] = Def.ActorFrame{
			MisoBold()..{
				Name = "Best Score "..i;
				InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(Top()+134+18*i):zoom(0.5):valign(0):shadowlength(1) end;
				OnCommand=function(self) self:settext("BEST #"..i) end;
			};
			MisoBold()..{
				Name = "Best Value "..i;
				InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+56):halign(0) else self:x(Right()-56):halign(1) end self:y(Top()+134+18*i):zoom(0.5):valign(0):shadowlength(1) end;
				OnCommand=function(self) self:settext(string.upper(GetSavedScore(pn,i):gsub(" ","")).." / "..string.upper(GetSavedStringGrade(pn,i))) end;
			};
		};
	end
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		CommonNormal()..{
			Name = "Current Session Stats";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(CenterY()-8):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext("CURRENT SESSION STATS"):diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)) end;
		};
		MisoBold()..{
			Name = "Accum Perfect+ Label";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(CenterY()-10+18):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext("PERFECTS"):diffuse(color(jColors[1])) end;
		};
		MisoBold()..{
			Name = "Accum Perfect+ Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+66):halign(0) else self:x(Right()-66):halign(1) end self:y(CenterY()-10+18):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext(string.format("%06.f",GetAccumStats(pn,9))):AddAttribute(0,{Length = LeadingToSixZerosForAccumStats(pn,9); Diffuse = ColorDarkTone(color(jColors[1]))}) end;
		};
		MisoBold()..{
			Name = "Accum Perfect Label";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(CenterY()-10+18*2):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext("PERFECTS"):diffuse(color(jColors[2])) end;
		};
		MisoBold()..{
			Name = "Accum Perfect Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+66):halign(0) else self:x(Right()-66):halign(1) end self:y(CenterY()-10+18*2):zoom(0.5):valign(0):shadowlength(1):diffuse(color(jColors[2])) end;
			OnCommand=function(self) self:settext(string.format("%06.f",GetAccumStats(pn,8))):AddAttribute(0,{Length = LeadingToSixZerosForAccumStats(pn,8); Diffuse = ColorDarkTone(color(jColors[2]))}) end;
		};
		MisoBold()..{
			Name = "Accum Great Label";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(CenterY()-10+18*3):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext("GREATS"):diffuse(color(jColors[3])) end;
		};
		MisoBold()..{
			Name = "Accum Great Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+66):halign(0) else self:x(Right()-66):halign(1) end self:y(CenterY()-10+18*3):zoom(0.5):valign(0):shadowlength(1):diffuse(color(jColors[3])) end;
			OnCommand=function(self) self:settext(string.format("%06.f",GetAccumStats(pn,7))):AddAttribute(0,{Length = LeadingToSixZerosForAccumStats(pn,7); Diffuse = ColorDarkTone(color(jColors[3]))}) end;
		};
		MisoBold()..{
			Name = "Accum Good Label";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(CenterY()-10+18*4):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext("GOODS"):diffuse(color(jColors[4])) end;
		};
		MisoBold()..{
			Name = "Accum Good Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+66):halign(0) else self:x(Right()-66):halign(1) end self:y(CenterY()-10+18*4):zoom(0.5):valign(0):shadowlength(1):diffuse(color(jColors[4])) end;
			OnCommand=function(self) self:settext(string.format("%06.f",GetAccumStats(pn,6))):AddAttribute(0,{Length = LeadingToSixZerosForAccumStats(pn,6); Diffuse = ColorDarkTone(color(jColors[4]))}) end;
		};
		MisoBold()..{
			Name = "Accum Bad Label";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(CenterY()-10+18*5):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) if not IsW5Disabled() then self:settext("BADS"):diffuse(color(jColors[5])) end end;
		};
		MisoBold()..{
			Name = "Accum Bad Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+66):halign(0) else self:x(Right()-66):halign(1) end self:y(CenterY()-10+18*5):zoom(0.5):valign(0):shadowlength(1):diffuse(color(jColors[5])) end;
			OnCommand=function(self) if not IsW5Disabled() then self:settext(string.format("%06.f",GetAccumStats(pn,5))):AddAttribute(0,{Length = LeadingToSixZerosForAccumStats(pn,5); Diffuse = ColorDarkTone(color(jColors[5]))}) end end;
		};
		MisoBold()..{
			Name = "Accum Miss Label";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(CenterY()-10+18*(IsW5Disabled() and 5 or 6)):zoom(0.5):valign(0):shadowlength(1) end;
			OnCommand=function(self) self:settext("MISSES"):diffuse(color(jColors[6])) end;
		};
		MisoBold()..{
			Name = "Accum Miss Result";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+66):halign(0) else self:x(Right()-66):halign(1) end self:y(CenterY()-10+18*(IsW5Disabled() and 5 or 6)):zoom(0.5):valign(0):shadowlength(1):diffuse(color(jColors[6])) end;
			OnCommand=function(self) self:settext(string.format("%06.f",GetAccumStats(pn,4))):AddAttribute(0,{Length = LeadingToSixZerosForAccumStats(pn,4); Diffuse = ColorDarkTone(color(jColors[6]))}) end;
		};
	};
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.Quad{
		InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(Bottom()-120+52):setsize(256,32):zoomx(0.99):zoomy(1.24):valign(1) end;
		OnCommand=function(self) self:diffusetopedge(Black()):diffusebottomedge(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)) end;
	};
	t[#t+1] = Def.GraphDisplay{
		InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+8):halign(0) else self:x(Right()-8):halign(1) end self:y(Bottom()-68):zoomx(0.99):zoomy(0.6):valign(1):playcommand("Load") end;
		LoadCommand=function(self)
			self:Load("GraphDisplay")
			local playerStageStats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn)
			local stageStats = STATSMAN:GetCurStageStats()
			self:Set(stageStats, playerStageStats)
		end;
	};	
end

return t